<?php 
	/*	
	*	Goodlayers Core Plugin Filter
	*	---------------------------------------------------------------------
	*	This file contains the script to includes necessary function
	* 	for compatibility with goodlayers core plugin
	*	---------------------------------------------------------------------
	*/

	// add body class for page builder
	add_filter('gdlr_core_page_builder_body_class', 'seocrawler_page_builder_body_class');
	if( !function_exists('seocrawler_page_builder_body_class') ){
		function seocrawler_page_builder_body_class( $classes ) {
			return $classes . ' seocrawler-body';
		}
	}
	add_filter('gdlr_core_sidebar_class', 'seocrawler_gdlr_core_sidebar_class');
	if( !function_exists('seocrawler_gdlr_core_sidebar_class') ){
		function seocrawler_gdlr_core_sidebar_class( $classes ) {
			return $classes . ' seocrawler-sidebar-area';
		}
	}

	// Set the neccessary function to be used in the theme
	add_action('after_setup_theme', 'seocrawler_goodlayers_core_setup');
	if( !function_exists( 'seocrawler_goodlayers_core_setup' ) ){
		function seocrawler_goodlayers_core_setup(){

			// to set the goodlayers core plugin pagination
			add_filter('gdlr_core_pagination_style', 'seocrawler_gdlr_core_pagination_style');
			add_filter('gdlr_core_pagination_align', 'seocrawler_gdlr_core_pagination_align');

			// set the default social share option
			add_filter('gdlr_core_social_share_list', 'seocrawler_gdlr_core_social_share_list');

			// widget title navigation
			add_filter('gdlr_core_widget_title_nav', 'seocrawler_gdlr_core_widget_title_nav');

			// single portfolio
			add_filter('gdlr_core_custom_post_slug', 'seocrawler_gdlr_core_custom_post_slug', 10, 2);

			add_filter('gdlr_core_portfolio_single_nav', 'seocrawler_gdlr_core_portfolio_single_nav');
			add_filter('gdlr_core_portfolio_single_nav_same_term', 'seocrawler_gdlr_core_portfolio_single_nav_same_term');
			add_filter('gdlr_core_portfolio_single_related', 'seocrawler_gdlr_core_portfolio_single_related');

			// srcset
			add_filter('gdlr_core_enable_srcset', 'seocrawler_gdlr_core_enable_srcset');

			// filter for portfolio icon hover
			add_filter('gdlr_core_portfolio_hover_icon_class', 'seocrawler_gdlr_core_portfolio_hover_icon_class');

		}
	}

	// portfolio hover icon class
	if( !function_exists('seocrawler_gdlr_core_portfolio_hover_icon_class') ){
		function seocrawler_gdlr_core_portfolio_hover_icon_class( $type = '' ){
			if( $type == 'image' ){
			 	return seocrawler_get_option('general', 'portfolio-icon-hover-image', '');
			}else if( $type == 'video' ){
				return seocrawler_get_option('general', 'portfolio-icon-hover-video', '');
			}else if( $type == 'link' ){
				return seocrawler_get_option('general', 'portfolio-icon-hover-link', '');
			}
		}
	}

	// to enable srcset
	if( !function_exists('seocrawler_gdlr_core_enable_srcset') ){
		function seocrawler_gdlr_core_enable_srcset( $enable ){
			$enable_srcset = seocrawler_get_option('plugin', 'enable-srcset', 'disable');
			return ($enable_srcset == 'enable');
		}
	}
			
	// for goodlayers core pagination
	if( !function_exists('seocrawler_gdlr_core_pagination_style') ){
		function seocrawler_gdlr_core_pagination_style( $style ) {
			return seocrawler_get_option('general', 'pagination-style', $style);
		}
	}
	if( !function_exists('seocrawler_gdlr_core_pagination_align') ){
		function seocrawler_gdlr_core_pagination_align( $align ) {
			return seocrawler_get_option('general', 'pagination-align', $align);
		}
	}			

	// custom post type slug
	if( !function_exists('seocrawler_gdlr_core_custom_post_slug') ){
		function seocrawler_gdlr_core_custom_post_slug( $slug, $type = '' ) {
			if( empty($type) ){ $type = $slug; }

			if( $type == 'portfolio' ){
				$slug = seocrawler_get_option('general', 'portfolio-slug', $slug);
			}else if( $type == 'portfolio_category' ){
				$slug = seocrawler_get_option('general', 'portfolio-category-slug', $slug);
			}else if( $type == 'portfolio_tag' ){
				$slug = seocrawler_get_option('general', 'portfolio-tag-slug', $slug);
			}else if( $type == 'personnel' ){
				$slug = seocrawler_get_option('general', 'personnel-slug', $slug);
			}else if( $type == 'personnel_category' ){
				$slug = seocrawler_get_option('general', 'personnel-category-slug', $slug);
			}
			
			return $slug;
		}
	}

	// single portfolio
	if( !function_exists('seocrawler_gdlr_core_portfolio_single_nav') ){
		function seocrawler_gdlr_core_portfolio_single_nav( $check ) {
			return seocrawler_get_option('general', 'enable-single-portfolio-navigation', $check);
		}
	}
	if( !function_exists('seocrawler_gdlr_core_portfolio_single_nav_same_term') ){
		function seocrawler_gdlr_core_portfolio_single_nav_same_term( $check ) {
			return seocrawler_get_option('general', 'enable-single-portfolio-navigation-in-same-tag', $check);
		}
	}
	if( !function_exists('seocrawler_gdlr_core_portfolio_single_related') ){
		function seocrawler_gdlr_core_portfolio_single_related( $args ) {

			$enble_related_portfolio = seocrawler_get_option('general', 'enable-related-portfolio', 'enable');
			if( $enble_related_portfolio == 'enable' ){
				$args['portfolio-style'] = seocrawler_get_option('general', 'related-portfolio-style', 'grid');
				$args['enable-portfolio-tag'] = seocrawler_get_option('general', 'related-portfolio-enable-tag', '');
				$args['num-fetch'] = seocrawler_get_option('general', 'related-portfolio-num-fetch', 4);
				$args['column-size'] = seocrawler_get_option('general', 'related-portfolio-column-size', 15);
				$args['thumbnail-size'] = seocrawler_get_option('general', 'related-portfolio-thumbnail-size', 'medium');
				$args['hover'] = seocrawler_get_option('general', 'related-portfolio-thumbnail-hover', '');
				$args['excerpt-number'] = seocrawler_get_option('general', 'related-portfolio-num-excerpt', 20);
				$args['portfolio-title-font-size'] = seocrawler_get_option('general', 'related-portfolio-title-font-size', '');
				$args['portfolio-title-font-weight'] = seocrawler_get_option('general', 'related-portfolio-title-font-weight', '');

				return $args;
			}else{
				return array();
			}
		}
	}

	// set default social share option
	if( !function_exists('seocrawler_gdlr_core_social_share_list') ){
		function seocrawler_gdlr_core_social_share_list( $social ) {

			$social['facebook'] = seocrawler_get_option('general', 'blog-social-facebook', $social['facebook']);
			$social['linkedin'] = seocrawler_get_option('general', 'blog-social-linkedin', $social['linkedin']);
			$social['google-plus'] = seocrawler_get_option('general', 'blog-social-google-plus', $social['google-plus']);
			$social['pinterest'] = seocrawler_get_option('general', 'blog-social-pinterest', $social['pinterest']);
			$social['stumbleupon'] = seocrawler_get_option('general', 'blog-social-stumbleupon', $social['stumbleupon']);
			$social['twitter'] = seocrawler_get_option('general', 'blog-social-twitter', $social['twitter']);
			$social['email'] = seocrawler_get_option('general', 'blog-social-email', $social['email']);

			return $social;
		}
	}	

	// add filter to register custom fonts for font lists 
	add_filter('gdlr_core_custom_uploaded_font', 'seocrawler_register_custom_uploaded_font');
	if( !function_exists('seocrawler_register_custom_uploaded_font') ){
		function seocrawler_register_custom_uploaded_font( $custom_fonts ){

			$custom_font = seocrawler_get_option('typography', 'font-upload');
			if( !empty($custom_font) ){
				foreach($custom_font as $font_option){
					$custom_fonts[$font_option['name']] = array(
						'eot' => $font_option['eot'],
						'ttf' => $font_option['ttf'],
					);
				}
			}		
			
			return $custom_fonts;
			
		} // seocrawler_register_custom_uploaded_font
	} // function_exists

	// format widget title
	if( !function_exists('seocrawler_gdlr_core_widget_title_nav') ){
		function seocrawler_gdlr_core_widget_title_nav( $title_nav ){
			return '</span><span class="gdlr-core-flexslider-nav gdlr-core-plain-style gdlr-core-size-widget">';
		}
	}
	
	// add page builder to post
	add_filter('gdlr_core_page_builder_post_type', 'seocrawler_gdlr_core_page_builder_post_type');
	if( !function_exists('seocrawler_gdlr_core_page_builder_post_type') ){
		function seocrawler_gdlr_core_page_builder_post_type( $post_types ){
			$post_types[] = 'post';
			return $post_types;
		}
	}

	// set lightbox type
	add_filter('gdlr_core_lightbox_type', 'seocrawler_gdlr_core_lightbox_type');
	if( !function_exists('seocrawler_gdlr_core_lightbox_type') ){
		function seocrawler_gdlr_core_lightbox_type(){
			$lightbox_type = seocrawler_get_option('plugin', 'lightbox', 'ilightbox');

			if( $lightbox_type == 'ilightbox' ){
				$ilightbox_skin = seocrawler_get_option('plugin', 'ilightbox-skin', 'dark');
				return $lightbox_type . '-' . $ilightbox_skin;
			}else{
				return $lightbox_type;
			}
		}
	}
	add_filter('body_class', 'seocrawler_lightbox_body_class');
	if( !function_exists('seocrawler_lightbox_body_class') ){
		function seocrawler_lightbox_body_class($class){
			$link_to_lightbox = seocrawler_get_option('plugin', 'link-to-lightbox', 'enable');
			if( $link_to_lightbox == 'enable' ){
				$class[] = 'gdlr-core-link-to-lightbox';
			}
			return $class;
		}
	}
	
	// add page builder pre defined template
	if( is_admin() && class_exists('gdlr_core_page_builder_template') ){
		add_filter('gdlr_core_page_builder_page_template_list', 'seocrawler_gdlr_core_page_builder_page_template_list');
		add_filter('gdlr_core_page_builder_get_page_template', 'seocrawler_gdlr_core_page_builder_get_page_template', 10, 2);
	}

	if( !function_exists('seocrawler_gdlr_core_page_builder_page_template_list') ){
		function seocrawler_gdlr_core_page_builder_page_template_list( $templates ){
			$templates['homepage'] = array(
				'title' => esc_html__('Homepage', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['homepage2'] = array(
				'title' => esc_html__('Homepage 2', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['homepage3'] = array(
				'title' => esc_html__('Homepage 3', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['code-optimization'] = array(
				'title' => esc_html__('Code Optimization', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['email-marketing'] = array(
				'title' => esc_html__('Email Marketing', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['seo-support'] = array(
				'title' => esc_html__('SEO Support', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['nap-syndication'] = array(
				'title' => esc_html__('Nap Syndication', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['target-strategy'] = array(
				'title' => esc_html__('Target Strategy', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['monitoring-ranking'] = array(
				'title' => esc_html__('Monitoring Ranking', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['search-engine-marketing'] = array(
				'title' => esc_html__('Search Engine Marketing', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['search-engine-optimization'] = array(
				'title' => esc_html__('Search Engine Optimization', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['about-our-team'] = array(
				'title' => esc_html__('About Our Team', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['about-us'] = array(
				'title' => esc_html__('About Us', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['free-analysis'] = array(
				'title' => esc_html__('Free Analysis', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['free-quote'] = array(
				'title' => esc_html__('Free Quote', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['contact'] = array(
				'title' => esc_html__('Contact', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['contact2'] = array(
				'title' => esc_html__('Contact 2', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['contact3'] = array(
				'title' => esc_html__('Contact 3', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['allen-walker-optimization'] = array(
				'title' => esc_html__('Allen Walker Optimization', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['dell-audience-monitoring'] = array(
				'title' => esc_html__('Dell Audience Monitoring', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['hp-cloud-service-improvment'] = array(
				'title' => esc_html__('HP Cloud Service Improvement', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['traveltour-marketing-campaign'] = array(
				'title' => esc_html__('Travel Tour Marketing Campaign', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['real-estate-web-rank-improve'] = array(
				'title' => esc_html__('Real Estate Web Rank Improve', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['kleanity-social-engagement'] = array(
				'title' => esc_html__('Kleanity Social Engagement', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['website-seo-optimization'] = array(
				'title' => esc_html__('Website SEO Optimization', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['conference-marketing'] = array(
				'title' => esc_html__('Conference Marketing', 'seocrawler'),
				'type' => 'wrapper',
			);
			return $templates;
		} // seocrawler_gdlr_core_page_builder_page_template_list
	} // function_exists

	if( !function_exists('seocrawler_gdlr_core_page_builder_get_page_template') ){
		function seocrawler_gdlr_core_page_builder_get_page_template( $value, $type ){

			if( !empty($value) ) return $value; 

			switch( $type ){
				case 'homepage': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"top-slider","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#282828","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"20"},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#ff4800","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.8","border-radius":{"top":"4px","right":"4px","bottom":"0px","left":"0px","settings":"unlink"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"23px","left":"0px","settings":"unlink"},"margin":{"top":"-77px","right":"0px","bottom":"0px","left":"30px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Free SEO Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"icon","left-icon":"icon_genius","left-image":"","title-left-icon":"icon_genius","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"21px","title-font-size":"21px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#ffffff","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4840","title":"Big Data Analysis","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4842","title":"Best Keyword Ranking","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4844","title":"Speed Optimization","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4841","title":"SEO Mobile Specialty","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4843","title":"Better Conversion","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4845","title":"Social Network Monitoring","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"hp-form","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#efeeee","background-image":"4848","background-image-style":"no-repeat","background-image-position":"bottom-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"45px","right":"20px","bottom":"30px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"30px","settings":"unlink"},"skin":"Contact form white"},"items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4846","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"*We will get back to you within 3 days","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4849","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4850","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4791","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Be on the top & Get more traffic  to your website","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"30px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.","text-align":"left","font-size":"17px","padding-bottom":"25px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_cloud_alt","icon-hover":"","title":"Be on the top of Google","link-url":""},{"icon":"icon_clock_alt","icon-hover":"","title":"Save your time and let us handle it","link-url":""},{"icon":"icon_desktop","icon-hover":"","title":"Cros-devices ability","link-url":""},{"icon":"icon_star_alt","icon-hover":"","title":"Be rewarded by our services","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","icon-size":"25px","content-size":"18px","list-bottom-margin":"24px","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Case Studies","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/portfolio-3-columns/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#ea4517","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"620px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"4851","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"5px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4851","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4791","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"30px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. ","text-align":"center","font-size":"17px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4852","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Code Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/code-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4858","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4859","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4763","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4853","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Monitoring Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/monitoring-ranking","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4854","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4781","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Target Strategy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/target-strategy","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4855","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4785","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Nap Syndication","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/nap-syndication/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4856","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4787","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Support","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/seo-support/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4857","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4789","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Email Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/email-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"15px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View More Services","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/our-services/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#ea4517","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"element","type":"divider"}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"805px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What drives your website great results","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"82px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>","text-align":"center","font-size":"17px","padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4731","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"24px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Page Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4732","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Internal Site Audit","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4733","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Content Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4734","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technical SEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4860","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Brand Awareness","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4861","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Local Search Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4862","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Mobile Search Improving","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4863","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"28px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Competitors Monitoring","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4878","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"video-bg-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"#161616","background-image":"4584","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.38","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"250px","right":"0px","bottom":"250px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4865","thumbnail-size":"full","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=F0uq5gyqIf8","page-id":"4791","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"580px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"video-bg-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4867","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"107px","right":"70px","bottom":"70px","left":"77px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Watch The Presentation","caption":"Bookmarksgrove right at the coast","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\n<p>of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her. powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of</p>\n","text-align":"left","font-size":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Story About Us","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/about-us/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#ea4517","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"640px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-screen-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"0px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We Know How To Code","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Dude.</p>","text-align":"left","font-size":"","padding-bottom":"30px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4869","title":"Digital Media Strategy","caption":"","content":"<p>Far far away, behind the word mountains.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4870","title":"Data Organization","caption":"","content":"<p>Separated they live in Bookmarksgrove</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4871","title":"Search Engine Friendly ","caption":"","content":"<p>Far far away, behind the word mountains.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-screen-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4873","background-image-style":"no-repeat","background-image-position":"bottom-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4735","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4749","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"32px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/free-analysis/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"/seocrawler/free-quote/","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"element","type":"divider"},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"770px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4882","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"58px","right":"0px","bottom":"57px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"What Clients Say?","title-left-icon":"","caption":"","tabs":[{"title":"John Doe","position":"Customer","content":"A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful.","image":"4875","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/testimonial-1.jpg","rating":""},{"title":"Jane Smith","position":"Web Marketing Analyst","content":"Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.","image":"4877","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/shutterstock_447504466.jpg","rating":""},{"title":"Paul Frank","position":"CEO Of Apple Corp.","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Donec sed odio dui. Vestibulum id ligula porta felis euismod semper.","image":"4876","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/shutterstock_342458267.jpg","rating":""}],"style":"center","column":"1","enable-quote":"disable","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-nav-style":"default","title-size":"26px","title-text-transform":"none","title-letter-spacing":"0px","caption-size":"16px","content-size":"20px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","title-wrap-bottom-margin":"40px","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"4883","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-1.png"},{"id":"4884","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-2.png"},{"id":"4885","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-3.png"},{"id":"4886","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-4.png"},{"id":"4887","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-5-150x33.png"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4893","background-image-style":"repeat-x","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.14","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4890","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"76px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Service Plans","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"price-table","value":{"id":"","class":"","tabs":[{"icon":"icon_genius","image":"","image-img":"","title":"Basic Plan","caption":"Suitable For Small Business","price":"100","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"},{"icon":"fa fa-star-o","image":"","image-img":"","title":"Advanced Plan","caption":"Suitable For Pro","price":"300","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"enable"},{"icon":"icon_lightbulb_alt","image":"","image-img":"","title":"Platinum Plan","caption":"Suitable For Enterprise","price":"500","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"}],"price-prefix":"$","price-suffix":"/ MO","header-color":"#81ca41","header-gradient-color":"#a4ca41","icon-color":"","title-color":"","caption-color":"#f8f8f8","price-background-color":"","price-prefix-color":"","price-text-color":"","price-suffix-color":"","content-background-color":"","content-color":"","content-border-color":"","button-text-color":"","button-background-color":"#81ca41","button-background-gradient-color":"","a-header-color":"#33a3cf","a-header-gradient-color":"#337dcf","a-icon-color":"","a-title-color":"","a-caption-color":"#f8f8f8","a-price-background-color":"","a-price-prefix-color":"","a-price-text-color":"","a-price-suffix-color":"","a-content-background-color":"","a-content-color":"","a-content-border-color":"","a-button-text-color":"","a-button-background-color":"#33a4cf","a-button-background-gradient-color":"","padding-bottom":"30px"}}]}]}]';
				case 'homepage2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#282828","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"45px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4935","title":"Big Data Analysis","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"28px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4938","title":"Best Keyword Ranking","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"25px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"25px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4936","title":"SEO Mobile Specialty","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"26px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4939","title":"Better Conversion","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"28px","bottom":"","left":"5px"},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4937","title":"Social Network Monitoring","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"25px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4940","title":"Speed Optimization","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"25px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4941","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Contact form grey"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Free SEO Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon_genius","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"28px","title-font-size":"25px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#3155a7","title-color":"#3155a7","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"-4px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4846","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"*We will get back to you within 3 days","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"75px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Be on the top & Get more traffic  to your website","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language.","text-align":"left","font-size":"17px","padding-bottom":"25px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_cloud_alt","icon-hover":"","title":"Be on the top of Google","link-url":""},{"icon":"icon_clock_alt","icon-hover":"","title":"Save your time and let us handle it","link-url":""},{"icon":"icon_desktop","icon-hover":"","title":"Cros-devices ability","link-url":""},{"icon":"icon_star_alt","icon-hover":"","title":"Be rewarded by our services","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#3155a7","icon-background-color":"","content-color":"#3155a7","border-color":"","icon-size":"25px","content-size":"18px","list-bottom-margin":"24px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Case Studies","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo2/portfolio-3-columns/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"border-radius":"4px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#111111","text-hover-color":"","background-color":"#3155a7","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"counter-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4942","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Purple Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"icon","top-icon":"fa fa-comments-o","top-text":"","prefix":"","start-number":"0","end-number":"2342","animation-time":"1000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"37px","top-text-size":"16px","number-size":"58px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"counter-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#19377d","background-image":"4942","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Purple Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"icon","top-icon":"icon_laptop","top-text":"","prefix":"","start-number":"0","end-number":"6302","animation-time":"1000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"37px","top-text-size":"16px","number-size":"58px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"counter-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4943","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Purple Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"icon","top-icon":"fa fa-star-o","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"1000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"37px","top-text-size":"16px","number-size":"58px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"counter-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#142d67","background-image":"4942","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Purple Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"icon","top-icon":"icon_easel","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"1000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"37px","top-text-size":"16px","number-size":"58px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"640px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-screen-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"50px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We Know How To Code","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Dude.</p>","text-align":"left","font-size":"","padding-bottom":"30px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_easel","icon-style":"normal","image":"4869","title":"Digital Media Strategy","caption":"","content":"Far far away, behind the word mountains.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"27px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"#3155a7","icon-background":"","background-color":"","media-margin":{"top":"13px","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_datareport","icon-style":"normal","image":"4870","title":"Data Organization","caption":"","content":"Separated they live in Bookmarksgrove","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"27px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"#3155a7","icon-background":"","background-color":"","media-margin":{"top":"13px","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_flowchart","icon-style":"normal","image":"4871","title":"Search Engine Friendly ","caption":"","content":"Far far away, behind the word mountains.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"27px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"#3155a7","icon-background":"","background-color":"","media-margin":{"top":"13px","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-screen-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4944","background-image-style":"cover","background-image-position":"bottom-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"video-bg-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"#161616","background-image":"4584","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.38","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"250px","right":"0px","bottom":"250px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4865","thumbnail-size":"full","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=F0uq5gyqIf8","page-id":"4791","custom-url":"","custom-link-target":"_self","overlay-icon-type":"none","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"580px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"video-bg-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#f2f2f2","background-image":"4867","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"70px","bottom":"75px","left":"77px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Watch The Presentation","caption":"Bookmarksgrove right at the coast","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\n<p>of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her. powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of</p>\n","text-align":"left","font-size":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Story About Us","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo2/about-us/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#81ca41","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"620px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4946","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.","text-align":"center","font-size":"17px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View More Services","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#3a3a3a","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4852","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Code Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/code-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4858","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4859","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4763","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4853","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Monitoring Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/monitoring-ranking","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4854","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4781","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Target Strategy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/target-strategy","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4855","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4785","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Nap Syndication","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/nap-syndication/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4856","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4787","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Support","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/seo-support/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4857","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4789","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Email Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/email-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4770","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"0px","left":"25px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Great Monitoring Tool","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove.","text-align":"left","font-size":"15px","padding-bottom":"10px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#3155a7","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Social Media Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia,<strong> there live the blind</strong> texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#3155a7","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"14px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4769","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4947","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4948","title":"Goal Discuss","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Conson antia, theree texts.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"70","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"45px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4949","title":"Strategy Planning","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Conson antia, theree texts.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"70","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"45px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4950","title":"Execution","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Conson antia, theree texts.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"70","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"45px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4951","title":"Monitoring","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Conson antia, theree texts.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"70","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"45px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#2a427a","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"CTA Purple"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"Interested in our service now?","caption":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live","button-text":"Request a free quote","button-link":"/seocrawler/demo2/free-quote/","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","button-border-radius":"3px","title-size":"36px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"17px","caption-letter-spacing":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"770px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"What Clients Say?","title-left-icon":"","caption":"","tabs":[{"title":"John Doe","position":"Customer","content":"A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful.","image":"4875","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/testimonial-1.jpg","rating":""},{"title":"Jane Smith","position":"Web Marketing Analyst","content":"Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.","image":"4877","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/shutterstock_447504466.jpg","rating":""},{"title":"Paul Frank","position":"CEO Of Apple Corp.","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Donec sed odio dui. Vestibulum id ligula porta felis euismod semper.","image":"4876","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/shutterstock_342458267.jpg","rating":""}],"style":"center","column":"1","enable-quote":"disable","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-nav-style":"default","title-size":"33px","title-text-transform":"none","title-letter-spacing":"0px","caption-size":"16px","content-size":"20px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","title-wrap-bottom-margin":"40px","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"4883","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-1.png"},{"id":"4884","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-2.png"},{"id":"4885","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-3.png"},{"id":"4886","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-4.png"},{"id":"4887","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-5-150x33.png"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"Case Studies","caption":"Far far away, behind the word mountains, far from the countries Vokalia and<br/> Consonantia, there live the blind texts. blind text by the name. ","caption-position":"bottom","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"33px","title-font-style":"","title-text-transform":"none","caption-size":"17px","caption-font-style":"normal","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"gdlr-core-plain-style"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"32px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo2/free-analysis/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"16px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#3155a7","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"/seocrawler/demo2/free-quote/","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"16px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"14px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"0px","icon-color":"","divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4893","background-image-style":"repeat-x","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.14","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Service Plans","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"24px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"price-table","value":{"id":"","class":"","tabs":[{"icon":"icon_genius","image":"","image-img":"","title":"Basic Plan","caption":"Suitable For Small Business","price":"100","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"},{"icon":"fa fa-star-o","image":"","image-img":"","title":"Advanced Plan","caption":"Suitable For Pro","price":"300","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"enable"},{"icon":"icon_lightbulb_alt","image":"","image-img":"","title":"Platinum Plan","caption":"Suitable For Enterprise","price":"500","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"}],"price-prefix":"$","price-suffix":"/ MO","header-color":"#d16142","header-gradient-color":"#d16142","icon-color":"","title-color":"","caption-color":"#f8f8f8","price-background-color":"","price-prefix-color":"","price-text-color":"","price-suffix-color":"","content-background-color":"","content-color":"","content-border-color":"","button-text-color":"","button-background-color":"#d16142","button-background-gradient-color":"","a-header-color":"#3155a7","a-header-gradient-color":"#3155a7","a-icon-color":"","a-title-color":"","a-caption-color":"#f8f8f8","a-price-background-color":"","a-price-prefix-color":"","a-price-text-color":"","a-price-suffix-color":"","a-content-background-color":"","a-content-color":"","a-content-border-color":"","a-button-text-color":"","a-button-background-color":"#3155a7","a-button-background-gradient-color":"","padding-bottom":"30px"}}]}]}]';
				case 'homepage3': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#282828","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"3","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"45px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_genius","icon-style":"normal","image":"4935","title":"Big Data Analysis","caption":"","content":"The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"38px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"#43a351","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_star_alt","icon-style":"normal","image":"4935","title":"SEO Mobile Specialty","caption":"","content":"The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"38px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"#43a351","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_easel","icon-style":"normal","image":"4935","title":"Social Network Monitoring","caption":"","content":"The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"38px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"#43a351","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#2a427a","background-image":"4959","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"CTA HP3"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"Interested in our service now?","caption":"Far far away, behind the word mountains far from the countries Vokalia and <br/>Consonantia, there live","button-text":"Request a free quote","button-link":"/seocrawler/demo3/free-quote/","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","button-border-radius":"3px","title-size":"36px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"17px","caption-letter-spacing":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4960","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"125px","right":"0px","bottom":"240px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1200px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What drives your website great results","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"45px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.","text-align":"center","font-size":"17px","padding-bottom":"55px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4961","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"24px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Page Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#ffffff","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4962","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Internal Site Audit","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#ffffff","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4963","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Content Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#ffffff","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4964","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technical SEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#ffffff","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-208px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4965","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4952","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Social Media Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia,<strong> there live the blind</strong> texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta.","text-align":"left","font-size":"16px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"29px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#43a351","text-hover-color":"#4c4c4c","background-color":"#3155a7","background-hover-color":"","background-gradient-color":"","border-color":"#43a351","border-hover-color":"#353535","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4966","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4967","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"0px","left":"25px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Great Monitoring Tool","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove.","text-align":"left","font-size":"15px","padding-bottom":"10px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#43a351","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4968","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"HP3 Service"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"830px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"4851","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"5px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Dud","text-align":"center","font-size":"17px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4852","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Code Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/code-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4858","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4859","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4763","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4853","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Monitoring Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/monitoring-ranking","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4854","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4781","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Target Strategy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/target-strategy","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4855","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4785","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Nap Syndication","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/nap-syndication/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4856","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4787","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Support","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/seo-support/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4857","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4789","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Email Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/email-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"15px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View More Services","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo3/our-services/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#494949","text-hover-color":"","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"analysis-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4969","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"90px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Be on the top & Get more traffic  to your website","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language.","text-align":"left","font-size":"17px","padding-bottom":"25px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_cloud_alt","icon-hover":"","title":"Be on the top of Google","link-url":""},{"icon":"icon_clock_alt","icon-hover":"","title":"Save your time and let us handle it","link-url":""},{"icon":"icon_desktop","icon-hover":"","title":"Cros-devices ability","link-url":""},{"icon":"icon_star_alt","icon-hover":"","title":"Be rewarded by our services","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#43a351","icon-background-color":"","content-color":"#43a351","border-color":"","icon-size":"25px","content-size":"18px","list-bottom-margin":"24px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Case Studies","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo3/portfolio-3-columns/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"border-radius":"4px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#111111","text-hover-color":"","background-color":"#3155a7","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"analysis-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"right","background-color":"","background-image":"4970","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"30px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-50px","settings":"unlink"},"skin":"Contact form green"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Free SEO Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon_genius","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"28px","title-font-size":"25px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#43a351","title-color":"#43a351","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"-4px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4846","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"*We will get back to you within 3 days","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4971","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"32px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo3/free-analysis/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#3375cf","background-hover-color":"#4c82ce","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"/seocrawler/demo3/free-quote/","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#1a4580","background2-hover-color":"#445c7f","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","text-transform":"","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#43a351","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"65px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"4972","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2017/07/hp3-banner-1-150x150.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4973","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2017/07/hp3-banner-2-150x150.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4975","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2017/07/hp3-banner-4-150x150.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4976","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2017/07/hp3-banner-5-150x150.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"4","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Recent Articles","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":"","num-fetch":"8","prepend-sticky":"enable","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-alignment":"left","blog-list-with-frame":"disable","always-show-overlay-content":"disable","show-thumbnail":"enable","thumbnail-size":"Portfolio Thumbnail","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"20","blog-date-feature":"enable","meta-option":["date","author","category","comment-number"],"show-read-more":"enable","blog-title-font-size":"24px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","padding-bottom":"60px","title-align":"center","title-left-icon":"","title":"","caption":"","caption-position":"top","read-more-text":"","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"17px","caption-font-style":"normal","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"15px","title-carousel-nav-style":"gdlr-core-plain-style"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#3375cf","background-hover-color":"#4c82ce","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#1a4580","background2-hover-color":"#445c7f","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]';
				case 'code-optimization': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4738","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"345px","right":"0px","bottom":"135px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Code Optimization","caption":"We are SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"90px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Aenean lacinia bibendum nulla sed consectetur. Donec id elit non mi porta gravida at eget metus.lacinia bibendum nulla sed consectetur. Praesent commodo.</p>","text-align":"left","font-size":"19px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"92px","padding-bottom":"30px","icon-color":"","divider-color":"#191919"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4741","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4743","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a team of experts","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4744","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Big Data Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4745","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Mobile Specialty","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4746","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Best Keyword Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4747","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Better Conversion","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"0px","icon-color":"","divider-color":""}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4749","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4750","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ]<strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'email-marketing': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4660","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4775","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Email Marketing","caption":"Service by SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"60px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. ","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"35px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1010px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4757","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4773","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"70px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"37px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"35px","icon-color":"","divider-color":"#262626"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, and but a few stray gleams steal into the inner sanctuary.","text-align":"center","font-size":"16px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4743","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a team of experts","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a","text-align":"left","font-size":"16px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.","text-align":"left","font-size":"16px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"805px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What drives your website great results","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"82px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>","text-align":"center","font-size":"17px","padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4731","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"24px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Page Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4732","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Internal Site Audit","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4733","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Content Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4734","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technical SEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#e85431","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4777","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Keyword Search","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#eeaf29","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4778","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Competitive Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#3e55c8","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4779","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Link Building","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#353535","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"10px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4780","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Web Marketing Analytics","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4749","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4750","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'seo-support': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4660","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4677","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"220px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Support","caption":"Service by SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"65px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. ","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"-210px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4661","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"55px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4743","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Trusted by big organizations","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"34px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4770","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Great Monitoring Tool","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Social Media Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4769","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4744","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Big Data Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4745","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Mobile Specialty","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4746","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Best Keyword Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4747","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Better Conversion","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4750","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4758","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Keyword Search","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4759","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Competitive Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4760","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Link Building","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"10px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4761","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Web Marketing Analytics","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4772","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"64px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1010px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"35px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"37px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is .a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind.","text-align":"center","font-size":"16px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#333333","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'nap-syndication': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4660","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1030px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4756","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Nap Syndication","caption":"Service by SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"66px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"4757","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. ","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"805px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What drives your website great results","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"34px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"82px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>","text-align":"center","font-size":"17px","padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4731","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"24px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Page Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4732","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Internal Site Audit","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4733","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Content Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4734","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technical SEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4771","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1010px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"35px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"37px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is .a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind.","text-align":"center","font-size":"16px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4770","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Great Monitoring Tool","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Social Media Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4769","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#e85431","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4777","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Keyword Search","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#eeaf29","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4778","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Competitive Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#3e55c8","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4779","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Link Building","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#353535","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"10px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4780","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Web Marketing Analytics","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#333333","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'target-strategy': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4738","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"265px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4783","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4781","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Target Strategy","caption":"We are SEO Crawler","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"90px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4743","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a team of experts","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4741","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. </p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Aenean lacinia bibendum nulla sed consectetur. Donec id elit non mi porta gravida at eget metus.","text-align":"left","font-size":"19px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"92px","padding-bottom":"30px","icon-color":"","divider-color":"#191919"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4762","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4744","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Big Data Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4745","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Mobile Specialty","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4746","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Best Keyword Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4747","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Better Conversion","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4784","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'monitoring-ranking': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4660","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4775","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Monitoring Ranking","caption":"Service by SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"60px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. ","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1010px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"35px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4776","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4773","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"70px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"37px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is .a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind.","text-align":"center","font-size":"16px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4743","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a team of experts","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a","text-align":"left","font-size":"16px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.","text-align":"left","font-size":"16px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#e85431","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4777","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Keyword Search","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#eeaf29","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4778","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Competitive Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#3e55c8","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4779","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Link Building","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#353535","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"10px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4780","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Web Marketing Analytics","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"805px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What drives your website great results","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"82px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>","text-align":"center","font-size":"17px","padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4731","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"24px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Page Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4732","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Internal Site Audit","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4733","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Content Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4734","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technical SEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"75px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"0px","icon-color":"","divider-color":""}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4749","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4750","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'search-engine-marketing': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4660","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4766","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Search Engine Marketing","caption":"Service by SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"60px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"4767","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"55px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. ","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4770","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Great Monitoring Tool","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Social Media Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4769","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4758","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Keyword Search","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4759","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Competitive Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4760","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Link Building","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"10px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4761","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Web Marketing Analytics","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4771","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Trusted by big organizations","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"34px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4772","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"64px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1010px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"35px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"37px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is .a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind.","text-align":"center","font-size":"16px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#333333","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'search-engine-optimization': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4660","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1030px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4756","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4757","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Search Engine Optimization","caption":"Service by SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"60px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. ","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4758","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Keyword Search","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4759","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Competitive Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4760","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Link Building","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"10px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4761","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Web Marketing Analytics","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1010px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"35px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"37px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is .a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind.","text-align":"center","font-size":"16px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4762","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"805px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What drives your website great results","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"34px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"82px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>","text-align":"center","font-size":"17px","padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4731","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"24px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Page Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4732","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Internal Site Audit","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4733","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Content Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4734","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technical SEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#333333","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'about-our-team': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4805","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"300px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Team","caption":"About us page","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"90px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"personnel-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4794","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"personnel-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f7f7f7","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"124px","right":"50px","bottom":"65px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Message From CEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence.","text-align":"left","font-size":"","padding-bottom":"20px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"John Smith","caption":"Cheif Executive Officer","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"/seocrawler/personnel/paul-walker/","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"personnel","value":{"id":"","class":"","category":["second-row"],"num-fetch":"4","orderby":"date","order":"desc","text-align":"center","personnel-style":"grid","enable-position":"enable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"disable","enable-social-shortcode":"disable","column-size":"4","thumbnail-size":"Personnel Thumbnail","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","carousel":"disable","carousel-autoslide":"enable","carousel-navigation":"navigation","personnel-title-font-size":"19px","personnel-title-font-weight":"600","personnel-title-letter-spacing":"","personnel-title-text-transform":"none","personnel-position-font-size":"15px","personnel-position-font-weight":"","personnel-position-font-style":"normal","personnel-position-letter-spacing":"","personnel-position-text-transform":"none","personnel-thumbnail-bottom-margin":"","personnel-title-bottom-margin":"","padding-bottom":"20px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4807","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a team of experts","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"34px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in<br />\nmoment; and yet I feel that I never was a greater artist than now. </p>\n","text-align":"left","font-size":"17px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.","text-align":"left","font-size":"17px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4808","title":"Big Data Analysis","caption":"","content":"Far far away, behind the word mountains, far from the countaries Vokalia and Consonantia, there live.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4809","title":"Best Keyword Ranking","caption":"","content":"Far far away, behind the word mountains, far from the countaries Vokalia and Consonantia, there live.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4810","title":"SEO Mobile Specialty","caption":"","content":"Far far away, behind the word mountains, far from the countaries Vokalia and Consonantia, there live.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4814","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"325px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}}]';
				case 'about-us': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4727","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"always-show","overlay-icon":"fa fa-play","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"#262626","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About our company","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"38px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"98px","padding-bottom":"40px","icon-color":"","divider-color":"#333333"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. <strong>Separated they live</strong> in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at</p>","text-align":"left","font-size":"","padding-bottom":"30px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_comment_alt","icon-style":"normal","image":"","title":"Digital Media Strategy","caption":"","content":"<p>Far far away, behind the word mountains.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"#282828","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"Data Organization","caption":"","content":"<p>Separated they live in Bookmarksgrove</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"#282828","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"fa fa-connectdevelop","icon-style":"normal","image":"","title":"Search Engine Friendly","caption":"","content":"<p>Separated they live in Bookmarksgrove</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"#282828","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"20px","icon-color":"","divider-color":""}},{"template":"wrapper","type":"background","items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Vision","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"38px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"98px","padding-bottom":"40px","icon-color":"","divider-color":"#333333"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. <strong>Separated they live</strong> in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitaerful Pointing has no control about the blind texts it is an almost unorthographic life.</p><p>One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn\'t listen. She packed.</p>","text-align":"left","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4729","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"always-show","overlay-icon":"fa fa-play","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"#262626","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4730","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"805px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What drives your website great results","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"82px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>","text-align":"center","font-size":"17px","padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4731","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"24px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Page Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4732","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Internal Site Audit","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4733","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Content Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4734","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technical SEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4735","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"805px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Get Free Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"41px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>","text-align":"center","font-size":"17px","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"17px","right":"31px","bottom":"17px","left":"31px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"","background-color":"#81ca41","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"15px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f4f4f4","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Contact form white"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4736","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"50px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Email Subscription","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"34px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Get updates from us!</p>","text-align":"center","font-size":"17px","padding-bottom":"20px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"rectangle","padding-bottom":"30px"}}]}]';
				case 'free-analysis': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4660","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1030px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4697","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Free SEO Analysis","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"66px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"4757","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. ","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Just Leave Us Your Information","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4983","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#333333","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]}]';
				case 'free-quote': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4738","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"265px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4783","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4781","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Request A Free Quote","caption":"We are SEO Crawler","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"90px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"800px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Please Complete This Form","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"34px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"60px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4986","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4743","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a team of experts","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4744","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Big Data Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4745","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Mobile Specialty","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4746","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Best Keyword Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4747","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Better Conversion","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4784","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-phone","text-align":"left","icon-size":"40px","icon-color":"#454545","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"55px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Phone","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these.</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">+1-2345-2345</a></p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-envelope-o","text-align":"left","icon-size":"40px","icon-color":"#454545","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"55px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Email","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these.</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">Contact@goodlayers.com</a></p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-location-arrow","text-align":"left","icon-size":"40px","icon-color":"#454545","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"55px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Location","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>4 apt. Flawing Street. The Grand Avenue.<br />Liverpool, UK 33342</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">View On Google Map</a></p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]}]}]';
				case 'contact': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4623","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"310px","right":"0px","bottom":"150px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Contact Us","caption":"Get Intouch","caption-position":"bottom","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"75px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"25px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"25px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-phone","text-align":"left","icon-size":"40px","icon-color":"#454545","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"55px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Phone","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these.</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">+1-2345-2345</a></p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-envelope-o","text-align":"left","icon-size":"40px","icon-color":"#454545","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"55px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Email","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these.</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">Contact@goodlayers.com</a></p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-location-arrow","text-align":"left","icon-size":"40px","icon-color":"#454545","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"55px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Location","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>4 apt. Flawing Street. The Grand Avenue.<br />Liverpool, UK 33342</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">View On Google Map</a></p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"680px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Contact form white"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"760px","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Leave us your info ","caption":"and we will get back to you.","caption-position":"bottom","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"39px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"40px","padding-bottom":"50px","icon-color":"","divider-color":"#2b2b2b"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1319","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","wpgmap-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"center","icon-size":"20px","with-text":"disable","text-size":"15px","icon-color":"#1e1e1e","icon-space":"40px","padding-bottom":"30px"}}]}]';
				case 'contact2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4738","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"320px","right":"0px","bottom":"140px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Contact Us","caption":"Get Intouch","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"75px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","caption-font-size":"25px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Contact form white"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Leave us your info ","caption":"","caption-position":"bottom","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"40px","padding-bottom":"30px","icon-color":"","divider-color":"#3a3a3a"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>","text-align":"left","font-size":"16px","padding-bottom":"25px"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1979","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Location","caption":"","caption-position":"bottom","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"40px","padding-bottom":"30px","icon-color":"","divider-color":"#3a3a3a"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>4 apt. Flawing Street. The Grand Avenue.<br />Liverpool, UK 33342</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"icon-list","value":{"id":"","tabs":[{"icon":"fa fa-envelope-o","icon-hover":"fa fa-envelope-o","title":"contact@infinitewptheme.com"},{"icon":"fa fa-phone","icon-hover":"fa fa-phone","title":"+1-3524-3356"}],"icon-size":"16px","content-size":"16px","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Map","caption":"","caption-position":"bottom","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"40px","padding-bottom":"30px","icon-color":"","divider-color":"#3a3a3a"}},{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"2","wpgmap2-id":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"75px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"#","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"center","icon-size":"20px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"37px","padding-bottom":"0px"}}]}]';
				case 'contact3': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4697","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"310px","right":"0px","bottom":"160px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Contact Us","caption":"Get Intouch","caption-position":"bottom","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"75px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"25px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"4784","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"65px","bottom":"80px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"London","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"104px","padding-bottom":"32px","icon-color":"","divider-color":"#ffffff"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>4 apt. Flawing Street. The Grand Avenue. Liverpool, UK 33342</p>\n<p>Tel : +44-20-2355-3456<br />\nEmail : London@InfiniteWP.com</p>\n","text-align":"left","font-size":"16px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"1","wpgmap2-id":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"4784","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"65px","bottom":"80px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"San Fran","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"113px","padding-bottom":"32px","icon-color":"","divider-color":"#ffffff"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>88 Flower Avenue. Kingdom St.<br />San Francisco CA 7689</p><p>Tel : +1-4533-4435-2<br />Email : Sanfran@InfiniteWP.com</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"3","wpgmap2-id":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"680px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Grey"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"760px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Contact form white"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Leave us your info ","caption":"and we will get back to you.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"43px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"40px","padding-bottom":"50px","icon-color":"","divider-color":"#2d2d2d"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1319","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"pulse","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"center","icon-size":"20px","with-text":"disable","text-size":"15px","icon-color":"#353535","icon-space":"40px","padding-bottom":"30px"}}]}]';
				case 'allen-walker-optimization': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4644","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"340px","right":"0px","bottom":"130px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Allen Walker Optimization","caption":"Improve Site Performance","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"57px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"29px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"40","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4648","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"google.com","custom-link-target":"_blank","overlay-icon-type":"none","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Project Detail","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. </p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Aenean lacinia bibendum nulla sed consectetur. Donec id elit non mi porta gravida at eget metus.lacinia bibendum nulla sed consectetur. Praesent commodo cursus magna.</p>","text-align":"left","font-size":"19px","padding-bottom":"15px"}},{"template":"element","type":"port-info","value":{"id":"","class":"","port-info":[{"key":"Client","value":"GoodLayers Inc."},{"key":"Project Date","value":"14 July 2017"}],"enable-post-type-tax":"disable","enable-bottom-border":"disable","taxonomy-head-text":"Tags","taxonomy":"portfolio_tag","enable-social-share":"disable","social-facebook":"enable","social-linkedin":"enable","social-google-plus":"enable","social-pinterest":"enable","social-stumbleupon":"enable","social-twitter":"enable","social-email":"disable","padding-bottom":"50px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"