<?php
/**
 * Plugin Name:       Event Registration
 * Description:       Event Registration start now!
 * Version:           1.0.0
 * Author:            Sana Ullah
 * Author URI:        https://www.psdtowordpresscoder.com/
 * Text Domain:       psdtowordpresscoder.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */
/*
 * Plugin constants
 */
 
defined( 'ABSPATH' ) or die( 'Nope, not accessing this' );
if(!defined('EVENTER_URL'))
	define('EVENTER_URL', plugin_dir_url( __FILE__ ));
if(!defined('EVENTER_PATH'))
	define('EVENTER_PATH', plugin_dir_path( __FILE__ ));
	
	class wp_event_registration_ER{
	public $eventer_db_version;
	public $_nonce;
	  
public function __construct(){
	 $this->eventer_db_version = '2.2.0';
    register_activation_hook(__FILE__, array($this, 'install'));
    add_action( 'admin_menu', array( $this, 'addAdminMenu' ) );
	add_action( 'wp_ajax_store_admin_data', array( $this, 'storeAdminData' ) );
	add_action( 'admin_enqueue_scripts', array( $this, 'addAdminScripts' ) );
	add_shortcode('EventRegistration', array($this, 'EventRegistrationshort'));
	add_action('wp_enqueue_scripts', array($this,'addFrontScripts'));
	add_action( 'wp_ajax_eventer_data', array( $this, 'eventer_data' ) );
	add_action( 'wp_ajax_nopriv_eventer_data', array( $this, 'eventer_data' ) );
	add_action('admin_init', array( $this, 'eventer_register_settings' ));
}
	
	
	
   //
  public function addAdminScripts()
  {
  wp_register_style('eventer', plugins_url('/assets/css/admin-style-eventer.css',__FILE__));
  wp_enqueue_style('eventer');

  }
	
	// Add Menu in Admin
	public function addAdminMenu(){
    add_menu_page(__( 'Event Registration', 'eventer' ),__( 'Event Registration', 'eventer' ),'manage_options','eventer',array($this, 'adminLayout'),'');
	add_submenu_page(__( 'eventer', 'eventer' ),__( 'Settings', 'eventer' ),__( 'Settings', 'eventer' ),'manage_options','eventer_setting',array($this, 'eventer_setting'),''); 
	
	 
}

// Add JS and CSS on front end
 public function addFrontScripts() {
 wp_register_style('eventer', plugins_url('/assets/css/eventer.css',__FILE__));
 wp_enqueue_style('eventer');
  wp_enqueue_script( 'eventerscript',  plugins_url('/assets/js/submit-front.js',__FILE__), array( 'jquery' ) );
  wp_enqueue_script('eventerscript');
 $admin_options = array(
	 'ajax_url' => admin_url( 'admin-ajax.php' ),
	 '_nonce'   => wp_create_nonce( $this->_nonce ),
      );
      wp_localize_script('eventerscript', 'eventer_exchanger', $admin_options);
 }
	
// Insatlled DB Table
		   public function install(){
		global $wpdb;
		global $eventer_db_version;
		$table_name = $wpdb->prefix . 'eventer';	
		$charset_collate = $wpdb->get_charset_collate();
		
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		/*$sql="DROP TABLE $table_name;";
		$wpdb->query($sql);*/
 $sql = "CREATE TABLE $table_name (
	  `dbID` int(10)  NOT NULL AUTO_INCREMENT,
  `EventID` int(10) NOT NULL,
  `emailAddress` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `location` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `option1` int(1) DEFAULT '0',
  `option2` int(1) DEFAULT '0',
  `option3` int(1) DEFAULT '0',
  `option4` int(1) DEFAULT '0',
  `option5` int(1) DEFAULT '0',
  `option6` int(1) DEFAULT '0',
  `createdDate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
     PRIMARY KEY  (dbID),
	 UNIQUE( `EventID`, `emailAddress`)
	) $charset_collate;";
	
		
		dbDelta( $sql );
		add_option( 'eventer_db_version', $eventer_db_version );
		$this->checkop();
}


private function checkop() {
 $eventer_settings = get_option('eventer_settings');


        //check if option is already present
        //option key is plugin_abbr_op, but can be anything unique
        if(!$eventer_settings['adminsubject']) {
            //not present, so add
            $op = array(
                'adminsubject' => 'One user get register on {eventid}',
			    'adminemail' => 'Hello Admin,
One user has submitted below Information

Event ID :  {eventid}
Email :  {email}
Location:  {location}
Option1:  {option1}
Option2:  {option2}
Option3:  {option3}
Option4:  {option4}
Option5:  {option5}
Option6:  {option6}

Thanks,
Admin
',
			    'useremailsubject' => 'Thanks for register on  {eventid}',
			    'useremail' => 'Thanks for submitting, We will get back to you.

Thanks
Admin',		  	
            );
            add_option('eventer_settings', $op);
        }
    }


public function eventer_setting(){?>
<div class="wrap">
<h1>Event Registration Settings</h1>

<form method="post" action="options.php">
<?php 

$eventer_settings = get_option('eventer_settings');
settings_fields('eventer_settings_group'); ?>
<div class="eventer-tabs-content eventer-main-setting-content">
    <table class="form-table  eventer-option-table eventer-main-setting-table">
    <caption>Event Registration Settings</caption>
    
       <tr valign="top">
        <th scope="row">Admin Email Submit</th>
        <td>
       <input type="text" name="eventer_settings[adminsubject]" value="<?php echo $eventer_settings['adminsubject']; ?>" />
        <p class="field-description">You can use these varibles in the email {eventid}, {email}, {location}, {option1... .option6}</p></td>
        </tr>
        
        
        <tr valign="top">
        <th scope="row">Admin Email</th>
        <td>
        <textarea  name="eventer_settings[adminemail]"><?php echo $eventer_settings['adminemail']; ?></textarea>
        <p class="field-description">You can use these varibles in the email {eventid}, {email}, {location}, {option1... .option6}</p></td>
        </tr>
         
      
        <tr valign="top">
        <th scope="row">User Email Submit</th>
        <td>
         <input type="text" name="eventer_settings[useremailsubject]" value="<?php echo $eventer_settings['useremailsubject']; ?>" />
        <p class="field-description">You can use these varibles in the email {eventid}, {email}, {location}, {option1... .option6}</p></td>
        </tr>
       <tr valign="top">
        <th scope="row">User Email</th>
        <td>
        <textarea  name="eventer_settings[useremail]"><?php echo $eventer_settings['useremail']; ?></textarea><p class="field-description">You can use these varibles in the email {eventid}, {email}, {location}, {option1... .option6}</p></td>
        </tr>
    </table>
    </div>
    <?php submit_button(); ?>

</form>
</div>
<?php
}


public function eventer_register_settings() {
	// creates our settings in the options table
	register_setting('eventer_settings_group', 'eventer_settings');
}

// Short Code Difination
 public function EventRegistrationshort($atts){
	include( plugin_dir_path( __FILE__ ) . 'inc/frontEndForm.php');	
	$form = frontFormeventer($atts);
	return $form;
}

// Admin Event Registers View
public function adminLayout(){
include( plugin_dir_path( __FILE__ ) . 'inc/adminLayout.php');	
}

public function eventer_data(){
global $wpdb;
$table_name = $wpdb->prefix . 'eventer';	

if ((wp_verify_nonce($_POST['security'], $this->_nonce ) === false) || empty($_POST['emailAddress']))
{echo __('Invalid Request!', 'eventer');
	die();
	}
$data = array('EventID' => $_POST['EventID'], 'emailAddress' => $_POST['emailAddress'], 'location' => $_POST['location'], 'option1' => $_POST['option1'], 'option2' => $_POST['option2'], 'option3' => $_POST['option3'], 'option4' => $_POST['option4'], 'option5' => $_POST['option5'], 'option6' => $_POST['option6']);
$format = array('%d','%s','%s','%d','%d','%d','%d','%d','%d');
$wpdb->insert($table_name,$data,$format);
$my_id = $wpdb->insert_id;	
setcookie("eventer".$_POST['EventID'], $my_id, time()+31536000,'/');
$this->emailto_admin_user($_POST);

echo __('Thanks for submit info!', 'eventer');
die();
}

public function emailto_admin_user($post){

$email = esc_attr($post['emailAddress']);
$location = esc_attr( $post['location']);
$EventID = esc_attr( $post['EventID'] );
$option1 = esc_attr( $post['option1'] );
$option1 = esc_attr( $post['option2'] );
$option1 = esc_attr( $post['option3'] );
$option1 = esc_attr( $post['option4'] );
$option1 = esc_attr( $post['option5'] );
$source = array('{eventid}','{email}','{location}','{option1}','{option2}','{option3}','{option4}','{option5}','{option6}');
$destination =  array($EventID,$email,$location,$option1,$option2,$option3,$option4,$option5,$option6);
$eventer_settings = get_option('eventer_settings');

 // Email to admin
$to = 'ullasana85@gmail.com'; //get_option('admin_email');

$to = get_option('admin_email');
$name = get_option('blogname');
$subject = str_replace($source,$destination,$eventer_settings['adminsubject']);
$content = str_replace($source,$destination,nl2br($eventer_settings['adminemail']));
$headers = array(
    'Reply-To' => $name . '<' . $email . '>',);
$headers = array('Content-Type: text/html; charset=UTF-8');
wp_mail( $to, $subject, $content, $headers);

 // Email to user
$to = $email; //get_option('admin_email');
$name = get_option('blogname');
$subject = str_replace($source,$destination,$eventer_settings['useremailsubject']);
$content = str_replace($source,$destination,nl2br($eventer_settings['useremail']));
$headers = array(
    'Reply-To' => $name . '<' . get_option('admin_email') . '>',);
$headers = array('Content-Type: text/html; charset=UTF-8');
wp_mail( $to, $subject, $content, $headers);




//remove_filter( 'wp_mail_content_type', 'set_html_content_type' );
}
public function set_html_content_type() {
    return 'text/html';
}

}
$wp_event_registration_ER = new wp_event_registration_ER();